# Event Handlers


```
Declare Function frmMain_Click( byref sender as wfxForm, _
                                byref e as EventArgs _
                                ) as LRESULT
```

This is a declaration for an **Event Handler**. Event handlers are functions that are called in response to something occurring within the operating system or in response to an action by the user. Windows is an **event based** operating system so when things happenn during the execution of your application, Windows will send messages to your program that you can respond to. For example, if the user clicks on a button or moves their mouse cursor over an area of the form or a control then an event is triggered. 

In the Windows API language this is actually a message or notification generated by the operating system that then flows through the application's message pump eventually finding its way to the procedure handler for the application. If you have ever seen Win32 API style programs then you will recognize functions containing large **SELECT CASE** statements having such things as **WM_COMMAND**, **WM_NOTIFY**, **WM_PAINT**, **WM_SIZE**, etc. The visual designer hides all of the complexity of message pumps and that **SELECT CASE** from you by instead redirecting the message to an Event Handler that you define yourself.

Every **Event Handler** has the exact same format and is comprised of two parameters that must be defined as **ByRef**.

Let's break down and explain the various parts of the **Event Handler** defined at the start of this document.

#### frmMain_Click
The portion before the underscore is the **form name** and the portion afterwards is the **name of the event** being responded to. In this case, the function is in response to someone clicking on an area of the form. If this event was in relation to say, a button control, then the name of the button would follow the name of the form. For example: **frmMain_btnOK_Click**

#### **sender**

A variable representing the form where the click occurred (eg. frmMain and is of the wfxForm class). 

You can interact with that variable and manipulate properties of the form:
```
sender.Text = "My new caption for the form's title bar!"
```

This is actually equivalent to using the form's explicitly defined shared variable and both are acceptable.

```
frmMain.Text = "My new caption for the form's title bar!"
```

When dealing with controls on a form, the syntax is only slightly different and pretty self-explanatory.
```
Declare Function frmMain_cmdOK_Click( byref sender as wfxButton, _
                                      byref e as EventArgs _
                                      ) as LRESULT
```

Of note is that **sender** is now of type **wfxButton** rather than **wfxForm**. This is because the function is in response to the user clicking on the OK button rather than the form itself.

#### **EventArgs**

This is an abbreviation for **Event Arguments** and is a variable that contains additional information related to the event being handled. For example, when handling mouse movement the **EventArgs** variable will contain the client coordinates of the mouse cursor and which (if any) mouse buttons are pressed. Likewise, responding to a **KeyPress** event the **EventArgs** variable would contain the character that was pressed and whether any Alt, Shift, or Ctrl keys are pressed. Get to know **EventArgs** because it is extremely convenient. 

```
Type wfxEventArgs Extends Object
   Private:
   Public:
      Message As UINT        ' Windows value of message being sent
      wParam as WPARAM       ' the wParam of the raw message
      lParam as LPARAM       ' the lParam of the raw message
      Handled as Boolean     ' indicates whether the event is handled by the user
      Cancel as boolean      ' set to True to cancel closing of Form
      Ctrl as Boolean        ' the CTRL key is pressed
      Alt as Boolean         ' the Alt key is pressed
      Shift as Boolean       ' the SHIFT key is pressed
      KeyChar as Long        ' stores the character corresponding to the key pressed
      KeyCode as Long        ' stores the keyboard code for the event
      LButton as Boolean     ' the left mouse button pressed
      MButton as Boolean     ' the middle mouse button pressed
      RButton as Boolean     ' the right mouse button pressed
      x as Long              ' the x-coordinate of the mouse click
      y as Long              ' the y-coordinate of the mouse click
      hDrop as HDROP         ' handle used for WM_DROPFILES message
End Type
```
